//****************************************************************//
//    Beta-Binormial Distribution Model
//     AUTHOR : S. Kido      
//     Scilab-5.5.0 
//　　　Mac OS-X　(10.9.3) version　
//     Update  :  June 9, 2014. 　　　　　　　　　
//****************************************************************//
//:-------------: Initialize :------------------------------------//
clear  ;     // clear workspace
funcprot(0); 
//clf();     // clear graphic window
//clc();     // clear console window
 chkflag = 0; 
//
//*****************************************************************//    
function TitleBBD()
// title page
mprintf('\n\n\n');       
mprintf('_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/\n');
mprintf('_/_/_/_/_/  The Reach & Frequency Estimation System　 _/_/_/_/_/\n');  
mprintf('_/         The TV Advertising Planning by BBD  Model          _/\n');
mprintf('_/        Estimating p2 by multiple regression method         _/\n');
mprintf('_/          Scilab-5.5 Mac-OS X 10.9 version                  _/\n');
mprintf('_/                Author  :  S. Kido                          _/\n');
mprintf('_/                Update  :  June 9, 2014.                    _/\n');
mprintf('_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/\n');  
//   
endfunction // end of TitleBBD()
//
//******************************************************************//    
function [ P_dmy ,N_sta,l,m,n,p1,p2,chkflag]=GUI_input_p1p2()
//function [ P_dmy ,N_sta,l,m,n,p1,p2,c,chkflag]=GUI_input_p1p2()    
//   GUI input p1 ,p2 and compute parameters: l, m 
//:-------------------------------------------------------------------//
 Title_txt='TV Advertising Planning System by BBD Model ';
   Prompt_txt = [' GRP:Gross Rating Points (%): ';...
                 ' Number of TV-Ad(Spot)      : ';...
                 ' Number of TV-Station       : ';...
                 ' All-Day Pattern or Not     : ';...
                  ];
  Def_Val = ['1200';'100';'5';'1']  ;  
  InputParam = x_mdialog(Title_txt, Prompt_txt,Def_Val )
//
GRP    = evstr(InputParam(1))
 n     = evstr(InputParam(2))
 N_sta = evstr(InputParam(3))
 P_dmy = evstr(InputParam(4)) 
//
 p1=GRP/n;
 GRP=p1*n;
 n=GRP/p1;
 p1=p1/100;
//
const  =0.0180357074720264;
alpha1 =0.000803512319829057;
alpha2 =-0.00520469136038004;
alpha3 =1.50904551134683;
//
    p2p1_ratio = const + alpha1*P_dmy + alpha2*N_sta + alpha3*p1;
    p2 = p1*p2p1_ratio;
//-------------------------------------------------------------
// feasiblity check of input data 
//:------------------------------------------------------------ 
if (p1 >1) then 
     x_dialog(['WARNING';'Enter Feasible p1 (GRP) :'],'(p1>1)');
// x_message('WARNING : Data(p1:%f) are not feasible in this Case (p1 >1)  \n',p1);   
 mprintf(' WARNING : Data(p1:%f) are not feasible in this Case (p1 >1)  \n',p1);  
elseif ((p1*p1 > p2) | (p1<= p2) )  then
x_dialog(['WARNING';'Enter Feasible p2 Data:'],'(p1*p1>p2) or (p1 < p2');
 mprintf(' WARNING : Data(p2:%f) are not feasible in this Case...
  [(p1*p1 > p2) or (p1 <= p2)]\n',p2);
       chkflag = 1;     
       [N_stal,m,n,p1,p2,chkflag]=GUI_input_p1p2(); 
    end 
//       
//:------------------------------------------------------------ 
// Compute parameters 
//-------------------------------------------------------------
     l=(p1*(p1-p2))/(p2-p1*p1);
     m=((1-p1)*(p1-p2))/(p2-p1*p1);
//
endfunction // end of GUI_input_p1p2()
//
//**********************************************************************//
function [r,Grp,AvFr,da]=CompRF(l,m,n,p1,p2)
// Compute Reach and Frequency Distribution
//:---------------------------------------------------------------------//
// Compute reach da(1,:)
     da=[];
      x=1;
     for  i=1:n;
        da(2,i)=(m+i-1)/(l+m+i-1);
        
            x=x*da(2,i);  // non reach
        da(1,i)=(1-x)*100; 
     end
// Compute Frequency Distribution da(2,:)
     da(2,1)=x*n*(l/(m+n-1));
//
     for  i=2:n; 
        da(2,i)=da(2,i-1)*((n-(i-1))/i)*((l+i-1)/(m+n-i));
     end
// Compute GRP, etc..
     Grp=n*p1*100;
     AvFr=Grp/da(1,n);
     r=da(1,n);
//   
     for  i=1:n; 
        da(2,i)=da(2,i)*100;
     end  
//
endfunction  // of CompRF() 
//
//************************************************************************//
function PlotRF(da)
//  plot reach and frequency
//-----------------------------------------------------------------------//
//　clf(); 
dt =1;
t = 1 : dt : n;
cr= da(1,t);
//cr3=da(3,t);
//cr3=da(5,t);
fd= da(2,t);
// 
 subplot(2,1,1);
  plot2d(t' ,cr') ;
  xtitle ('  Beta Binormial Distribution Model ::: Cum. Reach ');
  xgrid();
subplot(2,1,2);
 plot2d(t ,fd );
  xtitle ('  Beta Binormial Distribution Model ::: Frequency Distribution',...
        'Number of Insertion (n)');
  xgrid();
//  
endfunction // end of PlotRF()
//
//************************************************************************//
function DispResults(N_sta,p1,p2,l,m,n,r,grp,vrf,nm,bq3,chkflag,P_dmy)
//		Display of results
    mprintf('\n\n\n');
    mprintf('   TV Advertising Planning System by BBD Model \n');
    mprintf('      :-------------------------------------: \n');  
    mprintf('      :        Planning Conditions          : \n');
    mprintf('      :-------------------------------------: \n');
    mprintf('       GRP:Gross Rating Points (%%) : %6d \n',grp); 
    mprintf('       Number of TV-Ad(Spot)       : %6d  \n',n); 
    mprintf('       All-Day Pattern of Ad.      : %6d  \n',P_dmy); 
    mprintf('       Number of TV-Station        : %6d  \n',N_sta); 
    mprintf('      :-------------------------------------: \n');
    mprintf('\n\n');
//--------------------------------------------------------------
    mprintf('        ------ Parameters of Model ------\n');
    mprintf('               p1 :  %f \n',p1);
    mprintf('               p2 :  %f \n',p2);
    mprintf('                l :  %f \n', l);
    mprintf('                m :  %f \n', m);
    mprintf('                n :  %d \n', n);
    mprintf('        ---------------------------------\n\n\n');
//
    p2p1_ratio=p2/p1;
//    
    mprintf('      ------------ R E S U L T S -------------\n');
    mprintf('        Estimated Cum. Reach = %7.1f %% \n',r);
    mprintf('        Average  Frequency   = %7.1f  \n',AvFr);
    mprintf('        p2/p1 Ratio          = %7.6f  \n',p2p1_ratio);
    mprintf('      ----------------------------------------\n\n\n');
//
// output warning 
 MaxLn = n ;
 if (n >=10) then 
     MaxLn=evstr(x_dialog(['Summarize Display Output ?';'Enter Max. Line of Output :'],'10'));
     MX=floor(n/MaxLn);
 elseif (MaxLn == n)
          MX=1;
 end
 mprintf('Max. Lines   =  %5d\n',MaxLn); 
 //
 mprintf('  (N)    Frequency Distribution      Cumulative Reach   \n');
 for I=1:MX:n-1;
  mprintf(' %5d           %5.1f                     %5.1f  \n',...
            I,da(2,I),da(1,I));  
 end
  mprintf(' %5d           %5.1f                     %5.1f  \n',...
            n,da(2,n),da(1,n));  
//
 endfunction // end of DispResults
//
//************************************************************************//
function Output2File(N_sta,p1,p2,l,m,n,r,Grp,AvFr,chkflag,P_dmy)
//  Output to Text-file
//:-----------------------------------------------------------------------
//
Title='Beta-Binormial Distribution Model';
Prompt=[' Enter Output File Name: '];
//
// please specify output file location:full path names as below.
//
Def=['/Users/kidoshigeru/Desktop/BBDoutput1.txt'];
Answer=x_mdialog(Title,Prompt,Def);
//
Fid=mopen(Answer,'a')
//
  mfprintf(Fid,'\n\n');
  mfprintf(Fid,'Output File-Name :%s \n\n',Answer);
//:----------- Output to file ---------------------------------------
    mfprintf(Fid,'    TV Advertising Planning System by BBD Model \n ');
    mfprintf(Fid,'      :---------------------------------------: \n');  
    mfprintf(Fid,'      :        Planning Conditions            : \n');
    mfprintf(Fid,'      :---------------------------------------: \n');
    mfprintf(Fid,'       GRP:Gross Rating Points (%%) : %6d  \n',Grp); 
    mfprintf(Fid,'       Number of TV-Ad(Spot)       : %6d  \n',n); 
    mfprintf(Fid,'       All-Day Pattern of Ad.      : %6d  \n',P_dmy); 
    mfprintf(Fid,'       Number of TV-Station        : %6d  \n',N_sta);      
    mfprintf(Fid,'      :---------------------------------------: \n');
    mfprintf(Fid,'\n\n');
    mfprintf(Fid,'     [[ Beta Binormial Distribution Model ]]\n\n');
    mfprintf(Fid,'        ------ Parameters of Model ------\n');
    mfprintf(Fid,'               p1 :  %f \n',p1);
    mfprintf(Fid,'               p2 :  %f \n',p2);
    mfprintf(Fid,'                l :  %f \n', l);
    mfprintf(Fid,'                m :  %f \n', m);
    mfprintf(Fid,'                n :  %d \n', n);
    mfprintf(Fid,'        ---------------------------------\n\n\n');
    mfprintf(Fid,'       ------------ R E S U L T S -------------\n');
    mfprintf(Fid,'         Estimated Cum. Reach = %7.1f %% \n',r);
    mfprintf(Fid,'         Average  Frequency   = %7.1f  \n',AvFr);
    mfprintf(Fid,'       ----------------------------------------\n\n\n');
// 
mfprintf(Fid,'(N)    Frequency Distribution   Cumulative Reach  \n');
 for I=1:n;
mfprintf(Fid,' %5d         %5.1f                     %5.1f      \n',...
            I,da(2,I),da(1,I) );  
 end
 //
  if (chkflag == 1) then
   mfprintf(Fid, ' WARNING : Input Data(p2) are not feasible to BBD model');
   end
//     
 mclose(Fid);
//
  mprintf('\n\n');
  mprintf('Output to Text-file: Name is %s \n\n',Answer);
//
endfunction // end of Output2File
//
//************************************************************************//
//  Main program 
//:----------------------------------------------------------------------//
TitleBBD();
[ P_dmy ,N_sta,l,m,n,p1,p2,chkflag]=GUI_input_p1p2();
 [r,Grp,AvFr,da]=CompRF(l,m,n,p1,p2)
     DispResults(N_sta,p1,p2,l,m,n,r,Grp,AvFr,P_dmy);
       PlotRF(da);
       Output2File(N_sta,p1,p2,l,m,n,r,Grp,AvFr,chkflag,P_dmy);
//************************************************************************// 






